
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		blur_pixelRatio 0.0025

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float2 tex0			: TEXCOORD0;
};

struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float2 tex0			: TEXCOORD0;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_HDR( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	output.position = input.position;
	output.tex0 = input.tex0;

	return output;
}

sampler sampler_colour_0 = sampler_state { Texture = (shader_texture_0); AddressU = Wrap; AddressV = Wrap; MipFilter = LINEAR; };

float4 ps_HDR( VS_OUTPUT_HIGH input ) : COLOR0
{
	float4 finalShade = (tex2D(sampler_colour_0,input.tex0) +
						tex2D(sampler_colour_0,input.tex0-float2(blur_pixelRatio*1.5f,0.0f)) +
						tex2D(sampler_colour_0,input.tex0-float2(blur_pixelRatio*3.0f,0.0f)) +
						tex2D(sampler_colour_0,input.tex0+float2(blur_pixelRatio*1.5f,0.0f)) +
						tex2D(sampler_colour_0,input.tex0+float2(blur_pixelRatio*3.0f,0.0f)) +
						tex2D(sampler_colour_0,input.tex0-float2(0.0f,blur_pixelRatio*1.5f)) +
						tex2D(sampler_colour_0,input.tex0-float2(0.0f,blur_pixelRatio*3.0f)) +
						tex2D(sampler_colour_0,input.tex0+float2(0.0f,blur_pixelRatio*1.5f)) +
						tex2D(sampler_colour_0,input.tex0+float2(0.0f,blur_pixelRatio*3.0f))) / 9.0;

	return finalShade;
}



////////////////////////////////////////////////////////////

technique tech_HDR_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_HDR();	
		PixelShader = compile ps_2_0 ps_HDR();	
	}
}